//	DataStreams.h
//	Application creates an object of one of these classes and 
//	passes to Datatypes.lib functions.
//	Or application can define its own subclass of DStream for 
//	things like network connections.

#pragma once

#include <File.h>
#include <OS.h>
#include <stdlib.h>

#include "DStream.h"


#pragma export on

class DFileStream :
	public DStream
{
		BFile *					fFile;
		long					fOffset;
		long					fOpenMode;

		long					OpenFile();

public:
								DFileStream(
									BFile * file,	//	deleted by stream
									long openMode = B_READ_WRITE,
									long offset = 0);
								~DFileStream();

		long					Read(
									void * buffer,
									long & size);
		long					Write(
									const void * buffer,
									long size);
		long					Seek(
									long position);
		long					Position();
		long					Size();
		long					SetSize(
									long size);
};


class DMallocStream :
	public DStream
{
		void *					fPtr;
		long					fPhysSize;
		long					fLogSize;
		long					fLogPos;
		long					fOffset;

public:
								DMallocStream(
									void *ptr = NULL,	//	deleted by stream
									long size = 0,
									long offset = 0);
								~DMallocStream();

		long					Read(
									void * buffer,
									long & size);
		long					Write(
									const void * buffer,
									long size);
		long					Seek(
									long position);
		long					Position();
		long					Size();
		long					SetSize(
									long size);

virtual	const void *			Peek(
									long & outOffset,
									long & outSize);
};


class DAreaStream :
	public DStream
{
		area_id					fArea;
		void *					fPtr;
		long					fPhysSize;
		long					fLogSize;
		long					fLogPos;
		long					fOffset;

public:
								DAreaStream(
									area_id area = 0,	//	released by stream
									long size = 0,		//	needed because area has size multiple of page
									long offset = 0);
								~DAreaStream();

		long					Read(
									void * buffer,
									long & size);
		long					Write(
									const void * buffer,
									long size);
		long					Seek(
									long position);
		long					Position();
		long					Size();
		long					SetSize(
									long size);


virtual	const void *			Peek(
									long & outOffset,
									long & outSize);
};

#pragma export reset

